% AICS.cls - Artificial Intelligence & Cognitive Studies Journal Class
% Custom LaTeX document class for AICS submissions
% Version 1.1 - 2025-11-05
% Last updated: 2025-11-05
% Maintainer: AICS Editorial Team

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{AICS}[2025-11-05 v1.1 AICS Journal Class]

% Load base article class
\LoadClass[12pt,a4paper]{article}

% ============================================================================
% PACKAGES
% ============================================================================
\RequirePackage[utf8]{inputenc}
\RequirePackage[
  a4paper,
  margin=1in,
  headheight=14pt,
  includehead,
  includefoot
]{geometry}
\RequirePackage{graphicx}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage[hidelinks]{hyperref}
\RequirePackage{natbib}
\setcitestyle{round,authoryear}
\RequirePackage{fancyhdr}
\RequirePackage{setspace}
\RequirePackage{xcolor}
\RequirePackage{titlesec}
\RequirePackage[labelfont=bf, labelsep=colon]{caption}
\RequirePackage{booktabs}
\RequirePackage{siunitx}

% ============================================================================
% JOURNAL HEADER AND FOOTER
% ============================================================================
\pagestyle{fancy}
\fancyhf{}
\setlength{\headheight}{27.19pt} % Fix for fancyhdr warning
\rhead{\textit{Artificial Intelligence \& Cognitive Studies\\Interdisciplinary Perspectives}}
\lhead{\textit{[DO NOT EDIT THIS LINE.]}}
\cfoot{\thepage}
\renewcommand{\headrulewidth}{0.4pt}
\renewcommand{\footrulewidth}{0pt}

% ============================================================================
% TITLE, AUTHOR, AND DATE FORMATTING
% ============================================================================
\renewcommand{\@maketitle}{%
  \begin{center}%
    {\large\textbf{\@title}\par}%
    \vspace{12pt}%
    {\normalsize\@author\par}%
    \vspace{6pt}%
    {\small\@date\par}%
  \end{center}%
  \par
  \vspace{12pt}%
}

\renewcommand{\maketitle}{%
  \@maketitle
  \thispagestyle{fancy}%
}

% ============================================================================
% SECTION FORMATTING
% ============================================================================
\titleformat{\section}
  {\normalfont\large\bfseries}
  {\thesection}
  {1em}
  {}
  [\vspace{-0.5ex}]

\titleformat{\subsection}
  {\normalfont\normalsize\bfseries}
  {\thesubsection}
  {1em}
  {}
  [\vspace{-0.3ex}]

\titleformat{\subsubsection}
  {\normalfont\small\bfseries}
  {\thesubsubsection}
  {1em}
  {}
  [\vspace{-0.2ex}]

% ============================================================================
% ABSTRACT FORMATTING
% ============================================================================
\renewenvironment{abstract}{%
  \section*{Abstract}%
  \small%
  \vspace{-6pt}%
}{%
  \par%
  \vspace{6pt}%
}

% ============================================================================
% KEYWORDS COMMAND
% ============================================================================
\newcommand{\keywords}[1]{%
  \noindent%
  \textbf{Keywords:} #1%
  \par%
  \vspace{12pt}%
}

% ============================================================================
% AUTHOR AFFILIATION FORMATTING
% ============================================================================
\newcounter{affiliation}
\setcounter{affiliation}{0}

\newcommand{\affiliation}[1]{%
  \stepcounter{affiliation}%
  $^{\theaffiliation}$%
}

\newcommand{\affiliationtext}[2]{%
  $^{#1}$~#2%
}

% ============================================================================
% FIGURE AND TABLE FORMATTING
% ============================================================================
\renewcommand{\figurename}{Figure}
\renewcommand{\tablename}{Table}

\captionsetup{font=small, justification=justified}

% ============================================================================
% LINE SPACING FOR SUBMISSION
% ============================================================================
\onehalfspacing

% ============================================================================
% REFERENCE STYLE
% ============================================================================
\bibliographystyle{plainnat}
\renewcommand{\cite}{\citep}  % Force \cite to behave like \citep

% ============================================================================
% HYPERLINK COLORS
% ============================================================================
\hypersetup{
  colorlinks=true,
  linkcolor=blue,
  citecolor=blue,
  urlcolor=blue
}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\endinput